const Observer = new PageObserver({
    threshold: 0.6, // 100% of element must be visible
    rootMargin: '0px' // trigger 50px before element comes into view
});


/**
 * Accordion abserver
 */
Observer.observe('#accordionExample', (element, data) => {
    if (data.triggers === 1) {
        // Simply show first item
        const firstButton = element.querySelector('.accordion-button');
        firstButton.click();
    }
});

Observer.observe('#accordionExample1', (element, data) => {
    if (data.triggers === 1) {
        // Simply show first item
        console.log(data)
        const firstButton = element.querySelector('.accordion-button');
        firstButton.click();
    }
});
$( "#accordionExample1 .accordion-button" ).mouseover(function(){
    $(this).trigger("click");
});

/**
 * Impact section Slider
 */
Observer.observe('#impactSlider', (element, data) => {
    if (data.triggers === 1) {
        // Find the second slide
        const secondSlide = element.querySelector('.flexbox-slide:nth-child(2)');
        
        if (secondSlide) {
            // Remove slidebox-open from all slides
            element.querySelectorAll('.flexbox-slide').forEach(slide => {
                slide.classList.remove('slidebox-open');
            });
            
            // Add classes to second slide
            secondSlide.classList.add('selected');
            secondSlide.classList.add('slidebox-open');
            
            // Trigger click event programmatically
            secondSlide.click();
        }
    }
});
const timerObserver = new PageObserver({
    threshold: 1, // 100% of element must be visible
    rootMargin: '0px' // trigger 50px before element comes into view
});

timerObserver.observe('#countter', (element, data) => {
    if (data.triggers === 1) {
        
    $('.counter-count').each(function () {
        $(this).prop('Counter',0).animate({
            Counter: $(this).text()
        }, {
          
          //chnage count up speed here
            duration: 4000,
            easing: 'swing',
            step: function (now) {
                $(this).text(Math.ceil(now));
            }
        });
    });
    }
});